@echo off

set MYDIR=%CD%
set Path=%MYDIR%\bin\win32;%Path%


Rem Extract all files

md FIREHAWK
cd FIREHAWK
mex FIREHAWK ..\disks\FHAWKJPB.DSK
mex FIREHAWK ..\disks\FHAWKJPA.DSK
cd ..


if not exist disks\FHAWKJPA.DSK (
echo Error: disks\FHAWKJPA.DSK not found!
goto :eof
)

if not exist disks\FHAWKJPB.DSK (
echo Error: disks\FHAWKJPB.DSK not found!
goto :eof
)

Rem Create English disks using the translation patch
if exist translation\FH-EN-D1.IPS (
echo English Patch found.
copy /b disks\FHAWKJPA.DSK disks\FHAWKENA.DSK
copy /b disks\FHAWKJPB.DSK disks\FHAWKENB.DSK
uips a translation\FH-EN-D1.IPS disks\FHAWKENA.DSK
uips a translation\FH-EN-D2.IPS disks\FHAWKENB.DSK

md temp\FIREHAWKEN
cd temp\FIREHAWKEN
mex FIREHAWK ..\..\disks\FHAWKENB.DSK
mex FIREHAWK ..\..\disks\FHAWKENA.DSK
cd %MYDIR%
md FIREHAWK\LANGUAGE\EN
) ELSE (
echo English Patch not found.
)

Rem Set multi-language structure
md FIREHAWK\LANGUAGE\JP

copy /b FIREHAWK\DEMOFNT1.COM FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\DEMOFNT2.COM FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\EDM.DAT FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\ENEMY0.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\FH.COM FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\NAKADEMO.COM FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS0.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS1.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS2.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS3.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS4.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS5.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS6.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS7.BIN FIREHAWK\LANGUAGE\JP
copy /b FIREHAWK\THEXMIS8.BIN FIREHAWK\LANGUAGE\JP

if exist translation/FH-EN-D1.IPS (
copy /b temp\FIREHAWKEN\DEMOFNT1.COM FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\DEMOFNT2.COM FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\EDM.DAT FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\ENEMY0.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\FH.COM FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\NAKADEMO.COM FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS0.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS1.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS2.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS3.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS4.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS5.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS6.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS7.BIN FIREHAWK\LANGUAGE\EN
copy /b temp\FIREHAWKEN\THEXMIS8.BIN FIREHAWK\LANGUAGE\EN
rd /s /q temp\FIREHAWKEN
)
ren FIREHAWK\FIREHAWK.COM FIREHAWK.DOS

Rem And, finally, patch the files

call bin\xdelta3dir_FIREHAWK_apply.bat FIREHAWK

echo Please wait: generating checksums...
cd FIREHAWK
find . -type f |sort -d |xargs -n1 openssl dgst -sha1 >..\result.sha1
cd %MYDIR%
txtflip -u result.sha1

echo Complete.
echo ----------------------------------------------------
if exist translation/FH-EN-D1.IPS (
Rem diff result.sha1 patch\srcdir.sha1
fc patch\srcdir_jpen.sha1 result.sha1
) else (
fc patch\srcdir_jp.sha1 result.sha1
)
IF ERRORLEVEL 1 (
	echo Error: Some files were not updated correctly.
) ELSE (
	echo Patch successufly applied.
)

pause

