#!/bin/bash

# This patch upgrades FireHawk to HDD and a lot of new features (see README.TXT
# after patching)

# This script requires:
# openssl

UNAME=`uname`
export PATH="$PATH:bin/$UNAME"
MYDIR=`pwd`

if [ ! -f disks/FHAWKJPA.DSK ] ;then
	echo "Error: disks/FHAWKJPA.DSK not found!"
	exit
fi

if [ ! -f disks/FHAWKJPB.DSK ] ;then
	echo "Error: disks/FHAWKJPB.DSK not found!"
	exit
fi

# Create English disks using the translation patch
if [ -f translation/FH-EN-D1.IPS ] ;then
	echo "English Patch found."
	cp -f disks/FHAWKJPA.DSK disks/FHAWKENA.DSK
	cp -f disks/FHAWKJPB.DSK disks/FHAWKENB.DSK
	uips a translation/FH-EN-D1.IPS disks/FHAWKENA.DSK
	uips a translation/FH-EN-D2.IPS disks/FHAWKENB.DSK
	ENGLISH=1
	mkdir temp
else
	echo "English Patch not found."
fi

#Extract all files
bin/firehawk_extractfiles.sh disks/FHAWKJPB.DSK FIREHAWK
bin/firehawk_extractfiles.sh disks/FHAWKJPA.DSK FIREHAWK
rm -f FIREHAWK/#*
rm FIREHAWK/STARTUP.COM

if [ "a$ENGLISH" == "a1" ] ;then
	bin/firehawk_extractfiles.sh disks/FHAWKENB.DSK temp/FIREHAWKEN
	bin/firehawk_extractfiles.sh disks/FHAWKENA.DSK temp/FIREHAWKEN
	mkdir -p FIREHAWK/LANGUAGE/EN
fi

#Set multi-language structure
mkdir -p FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/DEMOFNT1.COM FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/DEMOFNT2.COM FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/EDM.DAT FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/ENEMY0.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/FH.COM FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/NAKADEMO.COM FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS0.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS1.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS2.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS3.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS4.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS5.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS6.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS7.BIN FIREHAWK/LANGUAGE/JP
cp -f FIREHAWK/THEXMIS8.BIN FIREHAWK/LANGUAGE/JP

if [ "a$ENGLISH" == "a1" ] ;then
	cp -f temp/FIREHAWKEN/DEMOFNT1.COM FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/DEMOFNT2.COM FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/EDM.DAT FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/ENEMY0.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/FH.COM FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/NAKADEMO.COM FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS0.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS1.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS2.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS3.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS4.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS5.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS6.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS7.BIN FIREHAWK/LANGUAGE/EN
	cp -f temp/FIREHAWKEN/THEXMIS8.BIN FIREHAWK/LANGUAGE/EN
	rm -rf temp/FIREHAWKEN
fi
mv FIREHAWK/FIREHAWK.COM FIREHAWK/FIREHAWK.DOS

#exit

# And, finally, patch the files
bin/xdelta3dir_FIREHAWK_apply.sh FIREHAWK

cd FIREHAWK
find . -type f |sort -d |xargs -n1 openssl dgst -sha1 >../result.sha1
cd $MYDIR

echo
echo "----------------------------------------------------"

if [ "a$ENGLISH" == "a1" ] ;then
diff patch/srcdir_jpen.sha1 result.sha1
else
diff patch/srcdir_jp.sha1 result.sha1
fi

if [ $? == 0 ] ;then
	echo "Patch successufly applied."
else
	echo "Error: Some files were not updated correctly." >&2
fi


