#!/bin/bash
# Backup v1.6



#------------------------------------------------------------------------

function backup_file(){

SRCFILE="$1"
FILENAME=`echo $SRCFILE |cut -f1 -d'.'`
FILEEXT=`echo $SRCFILE |cut -f2- -d'.'`

LASTVFILE="LASTVERSION.$FILENAME"

if [ ! -f "bkp/$LASTVFILE" ] ; then
	mkdir -p bkp
	echo "0" >bkp/$LASTVFILE
fi


LVERSION=`cat bkp/$LASTVFILE`
NVERSION=$(($LVERSION+1))
LVERSIONF=`printf "%03d" $LVERSION`	# Pad with zeroes
NVERSIONF=`printf "%03d" $NVERSION`	# Pad with zeroes

# Check if the last backup is really different
diff -q $SRCFILE bkp/$FILENAME.bkp$LVERSIONF.$FILEEXT >/dev/null 2>&1
if [ "$?" == "0" ]; then
	echo "$FILENAME.bkp$LVERSIONF.$FILEEXT is already up to date." |tee -a bkp/backup.log
else
	cp -v $SRCFILE bkp/$FILENAME.bkp$NVERSIONF.$FILEEXT
	echo bkp/$FILENAME.bkp$NVERSIONF.$FILEEXT >>bkp/backup.log
	echo $NVERSION >bkp/$LASTVFILE
fi

#cp ROM_patchOldRoutines.Z8A bkp/ROM_patchOldRoutines.bkp$VERSION.Z8A
#cp ROM_addnewRoutines.Z8A bkp/ROM_addnewRoutines.bkp$VERSION.Z8A
#cp RAM_addnewRoutines.Z8A bkp/RAM_addnewRoutines.bkp$VERSION.Z8A

}

#------------------------------------------------------------------------

echo "--------------------------" >>bkp/backup.log

for FILE in *.z80 ;do
	backup_file $FILE
done




