#!/bin/bash

#Config
MEGALZ="../../_utils/macOS/MegaLZ"
OUTDIR="."

#Initialization
IFS=$(printf "\t")
FILELIST=""
MODE="MLZ"

# Parse the command line
while [[ $# -gt 0 ]] ;do
	PARAM="$1"
	case ${PARAM} in
		-yaz)
			MODE="YAZ"	
			shift # Next parameter
		;;
		-outdir)
			shift # Next parameter
			OUTDIR="$1"
			shift # Next parameter
		;;
		^-.*)	# Catch-all for unrecognized parameters
			echo "Unrecognized parameter $1" >&2
			exit 2
		;;
		*)
			FILELIST="${FILELIST}${IFS}$1"
			shift # Next parameter
		;;
	esac
done


#---------------------------------------------------------------------------
function convMap {
	local JSONFILE="$1"
	local MAPNAME=$(basename "$1" | cut -f1 -d.)
	local OUTFILE="${MAPNAME}.yaz"
	local TMPFILE=$(mktemp)

	local firstGid=$(grep "firstgid" "${JSONFILE}" |sort |head -1 |cut -d, -f1 |cut -d: -f2)
	local DECDATA=($(grep "data" "${JSONFILE}" |awk -F'[][]' '{print $2}'| tr -s , "\t" ))
	local HEXDATA=""
	local v
	local adjV


for v in ${DECDATA[@]} ;do
	adjV=$[$v-$firstGid]
	if [ $adjV -lt 0 ] ; then  adjV=0 ;fi
	HEXDATA=${HEXDATA}$(printf "%02x" "$adjV")
done



if [ "${MODE}" == "MLZ" ] ;then
	# MLZ mode is for ROM development only
	HEXDATA="00000000000000"+${HEXDATA:(-761*2)} # Clear signature
	echo ${HEXDATA} | xxd -p -r - ${TMPFILE}

	rm -f ${OUTDIR}/${OUTFILE}
	${MEGALZ} ${TMPFILE} ${OUTDIR}/${OUTFILE}".mlz"
	rm ${TMPFILE}
else
	# YAZ mode is for external user levels
	HEXDATA="59617A7A696531"+${HEXDATA:(-761*2)} # Force signature
	echo ${HEXDATA} | xxd -p -r - ${OUTDIR}/${OUTFILE}
fi

}
#============================================================================

for FILE in ${FILELIST} ;do
	echo "Processing ${FILE}"
	convMap "${FILE}"
done

